qui {

noi {
	/*************************************************/
	/***** Step 2.4.2. Baseline results		    	**/
	/*************************************************/
}

	* 2.4.2.1. Export 5 most important optimal weights for each NIC

		* Reload master data
		cd ..
		cd ".\4. Master data"
		use master_data, clear
		cd ..
		replace cntry = "Serbia" if cntry == "ZzSerbia" 	// Correct country name
		
		* Export country-specific optimal weights
		noi di ""
		noi di "Export optimal weights for NIC:", _continue
		local count = 0
		foreach NIC in $NICs {
			
			* Identify NIC in current iteration
			preserve
			keep if cntrycode == `NIC'
			local NICname = cntry[1]
			restore
			
			* Collect optimal weights for its synthetic version
			preserve
			cd ".\3. Intermediary results\3.1. Simulated gaps\3.1.1.1. Weights"
			use cntry_weights1_`NIC', clear
			cap sum _W_Weight
			if _rc == 0 {
				if `r(N)' != 0 {
				
					local count = `count'+1
					noi di `count', _continue
			
					rename _Co_Number cntrycode
					rename _W_Weight weight
					keep cntrycode weight
					save weights_`NIC', replace
					restore
					
					merge m:1 cntrycode using weights_`NIC'
					drop _merge
					erase weights_`NIC'.dta 
					cd ..
					cd ..
					cd ..
					
					* Export 5 largest weights
					preserve
					duplicates drop cntry, force
					gsort -weight
					gen n = _n
					drop if n > 5
					keep cntry weight
					drop if weight == 0 | weight == .
					set obs 5
					rename cntry controlcntry
					gen NIC = "\hdashline\multirow{5}{*}{`NICname'}"
					order NIC weight controlcntry
					cd ".\3. Intermediary results"
					save w_`NIC', replace
					cd ..
					restore
					
					* Drop current-iteration weights
					drop weight
					}
				}	
			cap restore
			if  _rc == 0 {
				cd ..
				cd ..
				cd ..
				}
			}
			
		global totalNICs = `count'
		replace cntry = "ZzSerbia" if cntry == "Serbia"

		* Gather all optimal weights
		clear all
		cd ".\3. Intermediary results"
		foreach NIC in $NICs {
			cap append using w_`NIC'
			cap erase w_`NIC'.dta
			}
			
		* Implement some modifications for export to .tex format
		replace NIC = subinstr(NIC, "&", "\&", .)
		replace controlcntry = subinstr(controlcntry, "&", "\&", .)
		replace NIC = "\hdashline\multirow{5}{*}{Lesotho}" if NIC == "\hdashline\multirow{5}{*}{Basutoland (Lesotho)}" 	// Correct country name
		gsort +NIC -weight +controlcntry
	
		* Arrange data in two columns
		gen group = 1
		replace group = 2 if _n>(_N/2)+3
		
		gen n = _n
		replace n = round(n-_N/2-3) if _n>(_N/2)+3
		reshape wide NIC weight controlcntry, i(n) j(group)

		replace NIC1 = "" if NIC1 == NIC1[_n-1]
		replace NIC1 = "" if NIC1 == NIC1[_n-2]
		replace NIC1 = "" if NIC1 == NIC1[_n-3]
		replace NIC1 = "" if NIC1 == NIC1[_n-4]
		replace NIC2 = "" if NIC2 == NIC2[_n-1]
		replace NIC2 = "" if NIC2 == NIC2[_n-2]
		replace NIC2 = "" if NIC2 == NIC2[_n-3]
		replace NIC2 = "" if NIC2 == NIC2[_n-4]
		replace NIC2 = subinstr(NIC2, "\hdashline\multirow", "\multirow", .)
		drop n

		* Export table	
		cd ..
		cd ".\5. TeX results"
		listtab NIC1 controlcntry1 weight1 NIC2 controlcntry2 weight2 ///
		using tableA3.tex,  replace ///
		rstyle(tabular) ///
		headlines("\begin{longtable}{lcclcc} \caption{\normalsize \textbf{Optimal weights for synthetic NICs}} \label{tableA3}\\ \toprule \emph{NIC} &  \emph{Control country} &   $~w^{*}$ & \emph{NIC} &   \emph{Control country} &   $~w^{*}$ \\ \hline \endfirsthead \multicolumn{6}{c}{\textit{continued}} \\ \multicolumn{6}{c}{} \\ \endhead \multicolumn{6}{r}{\textit{continued on next page}} \\ \endfoot \multicolumn{6}{l}{} \\ \multicolumn{6}{l}{\scriptsize \textbf{Note:} This table lists the five largest optimal weights, $~w^{*}$, and the corresponding control countries for all the NICs in our sample.} \\ \multicolumn{6}{l}{ } \\ \endlastfoot") ///
		footlines("\end{longtable}")
		cd ..
		
	* 2.4.2.2. Export results for each NIC
	noi di ""
	noi di ""
	noi di "Export observed and counterfactual per capita GDP trajectories for NIC  (/$totalNICs):", _continue
	local j = 0
	foreach cntry of global NICs {
		
		* Load results
		cd ".\3. Intermediary results\3.4. Intermediaries"
		cap use IDD1_`cntry', clear
		cd ..
		cd ..
		if _rc == 0 {
		
			*Report progress
			local j = `j'+1
			noi di `j', _continue
		
			* Identify NIC
			replace cntry = "Lesotho" if cntry == "Basutoland (Lesotho)"
			replace cntry = "Rwanda" if cntry == "Ruanda"
			replace cntry = "Serbia" if cntry == "ZzSerbia"

			local cntryname = cntry[1]
			
			* Identify estimation window
			sum year if independence_years == 0 & cntrycode == `cntry'
			local independence_year = `r(mean)'
			sum year if cntrycode == `cntry' & baseline_lgdpcap != . & synth_lgdpcap != .
			local minyear = max(`r(min)',`independence_year'-31)
			local maxyear = min(`r(max)',`independence_year'+19)
			local min = max(`r(min)',`independence_year'-11)
			local max = min(`r(max)',`independence_year'-1)
			sum synth_lgdpcap if cntrycode == `cntry'
			local ceiling = 1.01*`r(max)'
			local floor = 1.01*`r(min)'
				
			* Plot the results
			sort cntrycode year
			twoway 	(scatteri `ceiling' `max' `ceiling' `min', bcolor(gs12) recast(area)) || ///
					(line baseline_lgdpcap year if year >= `minyear' & year <= `maxyear' & cntrycode == `cntry', lcolor(gs0)) || ///
					(line synth_lgdpcap year if year >= `minyear' & year <= `maxyear' & cntrycode == `cntry', lcolor(gs0) lpattern(dash)) || ///	
					,ytitle("log per capita GDP", size(large)) title(`cntryname', size(vlarge)) xtitle(Year, size(large)) legend(off) xline(`independence_year', lcolor(red) lpattern(shortdash)) graphregion(color(white)) bgcolor(white)
			cd ".\5. TeX results"
			graph export figureA3_`j'.pdf, replace
			cd ..
			}
		}

	* 2.4.2.3. Plot full-sample results
		
		* Gather all NIC-specific results
		clear all
		foreach cntry of global NICs {
			cd ".\3. Intermediary results\3.4. Intermediaries"
			cap append using IDD1_`cntry'
			cd .. 
			cd ..
			}
		keep cntry* year independence_years IDD rmspe
		cd ".\3. Intermediary results"
		save IDD1, replace
		cd ..
		
		* Add population data (to compute population weighted independence dividend estimates)
		// Use population shares in world population rather than raw population to avoid under-weighting early periods
		cd "./4. Master data"
		merge 1:1 cntrycode year using master_data, keepusing(popshare)
		keep if _merge == 3
		drop _merge
		cd ..
				
		* Collect data on 10, 20, ..., 100% best matched countries (in terms of their RMSPE)
		preserve
		duplicates drop cntrycode, force		// Collect NIC-specific RMSPE's
		sort rmspe
		sum cntrycode if rmspe != .
		scalar total_cntries = r(N)

		local i = 50
		foreach num of numlist 1 .75 .5 .25 {	// Collect RMSPE calipers defining the X% best matched cases (in terms of RMSPE)
			scalar pctge_`i' = `num' * 100
			local pctge_`i' =  pctge_`i'
			scalar best_`pctge_`i''pct = ceil(total_cntries*`num')
			local best_`pctge_`i''pct = best_`pctge_`i''pct
			sum rmspe in `best_`pctge_`i''pct'
			scalar cutoff_`pctge_`i'' = r(mean)
			local i = `i' - 10
			}
		restore
		
		* Add data-driven condition
		sum rmspe if independence_years == 0
		scalar cutoff_999 = 0.5*r(sd)	// Includes only those NICs which pre-independence paths are smaller then 0.5*the standard deviation of all RMSPEs, cf. caliper suggested by Rosenbaum & Rubin (1985) wrt. matching on propensity scores

		* Define thresholds of RMSPE for later usage
		global conditions 25 50 75 100 999
		
		* Compute raw independence dividend estimates

		noi di ""
		noi di ""
		noi di "Aggregate raw independence dividend estimates:"
		
		/* PART 1: raw country-specific independence dividend estimate paths */
			
			* Compute aggregate estimates, subject to various RMSPE cutoffs
			foreach condition of global conditions {
				gen agg_IDD_`condition' = .
				gen lower_ci_IDD_`condition' = .
				gen upper_ci_IDD_`condition' = .
				gen n_`condition' = .
				
				foreach year of numlist -10/30 {
					sum IDD if independence_years == `year' & rmspe <= cutoff_`condition' [w=popshare]
					replace agg_IDD_`condition' = r(mean) if independence_years == `year'
					}
				
				gen pretrend_`condition' = .
				sum IDD if independence_years >= -10 & independence_years <= -1 & rmspe <= cutoff_`condition'
				replace pretrend_`condition' = r(mean) if independence_years < 1
				
				gen posttrend_`condition' = .
				sum IDD if independence_years >= 0 & independence_years <= 30 & rmspe <= cutoff_`condition'
				replace posttrend_`condition' = r(mean) if independence_years > -1
				

				* Plot results
				label var independence_years "Years of independence"
				label var agg_IDD_`condition' "Average gap"
				
				foreach i in $NICs {
					local discrepancy  "`discrepancy' line IDD independence_years if cntrycode == `i', lc(gs13)  || "
					}
				
				sum cntrycode if agg_IDD_`condition' != . & rmspe <= cutoff_`condition' & independence_years == 30
				local helpme = `r(min)'
				
				sort cntrycode independence_years

				twoway `discrepancy' || ///
						(connected pretrend_`condition' independence_years, lcolor(red) lpattern(shortdash) lwidth(thin) msymbol(oh) mcolor(red)) || ///
						(connected posttrend_`condition' independence_years, lcolor(red) lpattern(shortdash) lwidth(thin)  msymbol(oh) mcolor(red)) || ///
						(connected agg_IDD_`condition' independence_years if cntrycode == `helpme', lcolor(gs0) mcolor(gs0)) if independence_years >= -10 & independence_years <= 30 & rmspe <= cutoff_`condition', xtitle("Years of independence", size(large)) ytitle("Independence dividend", size(large)) xline(0, lpattern(shortdash) lcolor(gs7) lstyle(foreground)) graphregion(color(white)) bgcolor(white) legend(off) xlab(-10(5)30)
				cd ".\5. TeX results"
				graph export figure4_`condition'.pdf, replace
				cd ..
				
		/* PART 2: report overall point estimates + RMSPE */
		
			* 1. Average post-independence independence dividend estimate (all NICs, 30 post-independence years)

				* Get average pre-independence percentage gap (y_NIC - y_synth) for each selection of countries
				sum pretrend_`condition'
				scalar avg_discrepancy_pre_`condition' = round(r(mean),.001)
					
				* Get average post-independence percentage gap (y_NIC - y_synth) for each selection of countries
				sum posttrend_`condition'
				scalar avg_discrepancy_post_`condition' = round(r(mean),.001)
				
				* Get average percentage gap (y_NIC - y_synth) in the 30th post-independence year for each selection of countries
				sum IDD if independence_years == 30 & IDD != . & rmspe <= cutoff_`condition'
				scalar discrepancy_30post_`condition' = round(r(mean),.001)
				
				noisily di "-> Best `condition'%: average pre-independence gap =", _continue
				noi di avg_discrepancy_pre_`condition', _continue
				noisily di ", average post-independence gap =", _continue
				noi di avg_discrepancy_post_`condition', _continue
				noisily di ", average gap in 30th post-independence year =", _continue
				noi di discrepancy_30post_`condition'
				}
			
			noi di ""
			
			* 2. Average RMSPE
			foreach condition of global conditions {
			preserve
			noisily di ""
			duplicates drop cntrycode, force
					sum rmspe if rmspe <= cutoff_`condition'
					local rmspe_`condition' = round(r(mean),.001)
					noisily di "Best `condition'%: average RMSPE =", _continue
					noi di `rmspe_`condition''
			restore
			}
			
	* 2.4.2.5. Perform KPSS level-stationarity test

		* Provide details and interpretation
		noi di "KPSS-test for level-stationarity of pre-independence discrepancies between actual and synthetic NICs" 
		noi di "- We test the level stationarity of pre-independence per capita GDP discrepancies between actual and synthetic NICs by a standard Kwiatkowski, Phillips, Schmidt, and Shin test, separately for each NIC in our sample."
		noi di "- We apply the test either on *all* pre-independence years or on the subsample of pre-independence years *excluding observations* in the estimation window."
		noi di "- Null hypothesis: variable was generated by a stationary process."
		noi di "- Alternative hypothesis: time series is not stationary."
		noi di "- Null is accepted, that is the DGP is deemed stationary, if the test statistic < critical value"
		noi di "- Optimal lag length chosen by the automatic bandwidth selection procedure proposed by Newey and West (1994) as described by Hobijn et al. (1998, 7)"
		noi di ""
		
		* Load data
		preserve
		cd "3. Intermediary results\3.4. Intermediaries"
		clear all
		forval i=1/317 {
			cap append using IDD1_all_`i'.dta
			}
		cd ..
		cd ..
			
		* Implement test
		
			* Define locals collecting test information
			
				* All years
				local n = 0
				local count_p1 = 0
				local count_p5 = 0
				local count_p10 = 0
				
				* Pre-estimation window years
				local n2 = 0
				local count2_p1 = 0
				local count2_p5 = 0
				local count2_p10 = 0
				
			* Implement test
			noi di "KPSS test:", _continue	
			levelsof cntrycode, local(cntries)
			foreach cntry in `cntries' {
			
				noi di ., _continue

				* Perform KPSS test
				
					* ALL YEARS
					cap kpss IDD if cntrycode == `cntry' & independence_years <= -1, notrend auto
					if _rc == 0 {
					
						* Gather results
						local n = `n'+1		// Count total # cases
						forval i=0/20 {
						if r(kpss`i') != . {
							local test_statistic = r(kpss`i')	// Collect value of test statistics at optimal lag (= last reported test statistic)
							}
						}
						if `test_statistic' < .347 {
							local count_p10 = `count_p10' + 1	// Count # cases for which the null hypothesis of level stationarity at the 10% significance level
							}
						if `test_statistic' < .463 {
							local count_p5 = `count_p5' + 1		// Count # cases for which the null hypothesis of level stationarity at the 5% significance level
							}
						if `test_statistic' < .739 {
							local count_p1 = `count_p1' + 1	// Count # cases for which the null hypothesis of level stationarity at the 1% significance level
							}
						}
					* PRE-ESTIMATION WINDOW YEARS ONLY
					cap kpss IDD if cntrycode == `cntry' & independence_years <= -11, notrend auto
					if _rc == 0 {
					
						* Gather results
						local n2 = `n2'+1		// Count total # cases
						forval i=0/20 {
						if r(kpss`i') != . {
							local test_statistic = r(kpss`i')	// Collect value of test statistics at optimal lag (= last reported test statistic)
							}
						}
						if `test_statistic' < .347 {
							local count2_p10 = `count2_p10' + 1	// Count # cases for which the null hypothesis of level stationarity at the 10% significance level
							}
						if `test_statistic' < .463 {
							local count2_p5 = `count2_p5' + 1	// Count # cases for which the null hypothesis of level stationarity at the 5% significance level
							}
						if `test_statistic' < .739 {
							local count2_p1 = `count2_p1' + 1	// Count # cases for which the null hypothesis of level stationarity at the 1% significance level
							}
						}
				
					}
			
			restore
			
			* Report results
			
			noi di ""
			noi di ""
			noi di "Results including all available pre-independence years:"
			noi di "--------------------------------------------------------"
			noi di "The null hypothesis of level stationarity cannot be rejected at the 10% significance level for", _continue 
			noi di round(`count_p10'/`n'*100,.1), _continue 
			noi di "% (= `count_p10'/`n') of the cases"
			noi di "The null hypothesis of level stationarity cannot be rejected at the 5% significance level for", _continue 
			noi di round(`count_p5'/`n'*100,.1), _continue 
			noi di "% (= `count_p5'/`n') of the cases"
			noi di "The null hypothesis of level stationarity cannot be rejected at the 1% significance level for", _continue 
			noi di round(`count_p1'/`n'*100,.1), _continue 
			noi di "% (= `count_p1'/`n') of the cases"
			
			noi di ""
			noi di ""
			noi di "Results when excluding data-points in estimation window:"
			noi di "--------------------------------------------------------"
			noi di "The null hypothesis of level stationarity cannot be rejected at the 10% significance level for", _continue 
			noi di round(`count2_p10'/`n2'*100,.1), _continue 
			noi di "% (= `count2_p10'/`n2') of the cases"
			noi di "The null hypothesis of level stationarity cannot be rejected at the 5% significance level for", _continue 
			noi di round(`count2_p5'/`n2'*100,.1), _continue 
			noi di "% (= `count2_p5'/`n2') of the cases"
			noi di "The null hypothesis of level stationarity cannot be rejected at the 1% significance level for", _continue 
			noi di round(`count2_p1'/`n2'*100,.1), _continue 
			noi di "% (= `count2_p1'/`n2') of the cases"
		
	* Reroute to directory containing dofiles
	cd ".\1. Dofiles"
	}
